<?php
class AdminInputNilai {
  private PDO $db;
  public function __construct(PDO $pdo){ $this->db=$pdo; }

  public function form(){
    $classes=$this->db->query("SELECT * FROM classes ORDER BY name")->fetchAll();
    $subjects=$this->db->query("SELECT * FROM subjects ORDER BY name")->fetchAll();
    $terms=$this->db->query("SELECT * FROM terms ORDER BY id DESC")->fetchAll();

    $sel_class=(int)($_GET['class_id']??0);
    $sel_sub=(int)($_GET['subject_id']??0);
    $sel_term=(int)($_GET['term_id']??0);

    $students=[];
    if($sel_class&&$sel_sub&&$sel_term){
      $st=$this->db->prepare("SELECT id,full_name FROM users WHERE role='siswa' AND class_id=? ORDER BY full_name");
      $st->execute([$sel_class]); 
      $students=$st->fetchAll();

      // prefilling nilai teori & rubrik
      $qTheo=$this->db->prepare("SELECT score FROM theory_scores WHERE student_id=? AND subject_id=? AND term_id=?");
      $qRub =$this->db->prepare("SELECT * FROM uml_rubric_scores WHERE student_id=? AND subject_id=? AND term_id=?");

      foreach($students as &$s){
        $qTheo->execute([$s['id'],$sel_sub,$sel_term]);
        $s['theory']=$qTheo->fetchColumn()??'';

        $qRub->execute([$s['id'],$sel_sub,$sel_term]);
        $row=$qRub->fetch(PDO::FETCH_ASSOC);
        $keys=['uc_actors','uc_relations','uc_fit','uc_naming','uc_neat','act_complete','act_symbols','act_fit','act_neat','bonus'];
        foreach($keys as $k){ $s[$k]=$row[$k]??''; }
      }
    }

    render_view('admin_input_form.php',compact('classes','subjects','terms','sel_class','sel_sub','sel_term','students'));
  }

  public function save(){
    if($_SERVER['REQUEST_METHOD']!=='POST'){ http_response_code(405); exit; }
    if(function_exists('csrf_verify') && isset($_POST['csrf'])) csrf_verify();

    $class=(int)$_POST['class_id'];
    $sub  =(int)$_POST['subject_id'];
    $term =(int)$_POST['term_id'];

    // 1) Teori
    $insTheo=$this->db->prepare(
      "INSERT INTO theory_scores(student_id,subject_id,term_id,score)
       VALUES(?,?,?,?)
       ON DUPLICATE KEY UPDATE score=VALUES(score), updated_at=NOW()"
    );

    // 2) Rubrik UML (PERBAIKAN: 13 placeholder, sesuai 13 kolom)
    $insRub=$this->db->prepare(
      "INSERT INTO uml_rubric_scores
        (student_id,subject_id,term_id,
         uc_actors,uc_relations,uc_fit,uc_naming,uc_neat,
         act_complete,act_symbols,act_fit,act_neat,bonus)
       VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)  -- <- 13 tanda tanya
       ON DUPLICATE KEY UPDATE
         uc_actors=VALUES(uc_actors),
         uc_relations=VALUES(uc_relations),
         uc_fit=VALUES(uc_fit),
         uc_naming=VALUES(uc_naming),
         uc_neat=VALUES(uc_neat),
         act_complete=VALUES(act_complete),
         act_symbols=VALUES(act_symbols),
         act_fit=VALUES(act_fit),
         act_neat=VALUES(act_neat),
         bonus=VALUES(bonus),
         updated_at=NOW()"
    );

    $this->db->beginTransaction();
    try {
      foreach($_POST['score'] as $sid=>$row){
        // Teori
        $theo = isset($row['theory']) ? (float)$row['theory'] : 0;
        $insTheo->execute([(int)$sid,$sub,$term,$theo]);

        // Rubrik
        $keys=['uc_actors','uc_relations','uc_fit','uc_naming','uc_neat',
               'act_complete','act_symbols','act_fit','act_neat','bonus'];
        $vals=[];
        foreach($keys as $k){
          $v = (int)($row[$k] ?? 0);
          $vals[] = $v;
        }
        // Gabungkan menjadi 13 nilai (sid, sub, term + 10 rubrik)
        $params = array_merge([(int)$sid, $sub, $term], $vals);
        $insRub->execute($params);
      }
      $this->db->commit();

    } catch (Throwable $e){
      $this->db->rollBack();
      // Tampilkan pesan error yang jelas di browser
      http_response_code(500);
      echo "Gagal menyimpan nilai: ".htmlspecialchars($e->getMessage());
      return;
    }

    header("Location:?action=admin_input&class_id=$class&subject_id=$sub&term_id=$term");
  }
}
