<?php
class AdminStudents {
    private PDO $db;
    public function __construct(PDO $pdo){ $this->db=$pdo; }

    public function index() {
        $st=$this->db->query("SELECT u.*,c.name AS class_name
                              FROM users u LEFT JOIN classes c ON u.class_id=c.id
                              WHERE role='siswa' ORDER BY full_name");
        $students=$st->fetchAll(PDO::FETCH_ASSOC);
        render_view('admin_students_index.php',compact('students'));
    }

    public function create() {
        $classes=$this->db->query("SELECT * FROM classes ORDER BY name")->fetchAll();
        render_view('admin_students_form.php',compact('classes'));
    }

    public function store() {
        $name=$_POST['full_name']??'';
        $email=$_POST['email']??'';
        $pass=$_POST['password']??'';
        $class=$_POST['class_id']??null;
        if(!$name||!$email||!$pass){
            $error="Semua field wajib diisi.";
            $classes=$this->db->query("SELECT * FROM classes")->fetchAll();
            render_view('admin_students_form.php',compact('error','classes'));return;
        }
        $st=$this->db->prepare("INSERT INTO users(role,email,password,full_name,class_id)
                                VALUES('siswa',?,?,?,?)");
        $st->execute([$email,$pass,$name,$class]);
        header("Location:?action=admin_students");
    }
}
