<?php
class AuthController {
    private PDO $db;
    public function __construct(PDO $pdo){ $this->db = $pdo; }

    /** GET: tampilkan form | POST: proses login */
    public function login() {
        if (session_status() === PHP_SESSION_NONE) session_start();
        if (isset($_SESSION['user'])) { header('Location:?action=home'); exit; }

        $error = null;

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Jika CSRF helper aktif, verifikasi token
            if (function_exists('csrf_verify') && isset($_POST['csrf'])) csrf_verify();

            $email = trim($_POST['email'] ?? '');
            $pass  = trim($_POST['password'] ?? '');

            if ($email === '' || $pass === '') {
                $error = 'Email dan password wajib diisi.';
            } else {
                $st = $this->db->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
                $st->execute([$email]);
                $u = $st->fetch(PDO::FETCH_ASSOC);

                if (!$u) {
                    $error = 'Email tidak ditemukan.';
                } elseif ($u['password'] !== $pass) { // catatan: masih plain sesuai setup latihan
                    $error = 'Password salah.';
                } else {
                    // Sukses: set session minimal
                    $_SESSION['user'] = [
                        'id'        => (int)$u['id'],
                        'role'      => $u['role'],
                        'email'     => $u['email'],
                        'full_name' => $u['full_name'] ?? ''
                    ];
                    header('Location:?action=home'); exit;
                }
            }
        }

        render_view('login.php', compact('error'));
    }

    /** GET: logout */
    public function logout() {
        if (session_status() === PHP_SESSION_NONE) session_start();
        session_destroy();
        header('Location:?action=login'); exit;
    }
}
