<?php
class StudentReport {
  private PDO $db;
  public function __construct(PDO $pdo){ $this->db=$pdo; }

  public function show(){
    if (session_status()===PHP_SESSION_NONE) session_start();
    $u = $_SESSION['user'] ?? null;
    if(!$u || $u['role']!=='siswa'){ header('Location:?action=login'); exit; }

    // ambil subject & term terbaru (paling akhir)
    $subject = $this->db->query("SELECT id,name FROM subjects ORDER BY id DESC LIMIT 1")->fetch();
    $term    = $this->db->query("SELECT id,name FROM terms ORDER BY id DESC LIMIT 1")->fetch();

    $theori = 0.0; $rubrik=[]; $praktik=0.0; $total_nilai=null;
    if($subject && $term){
      $st=$this->db->prepare("SELECT score FROM theory_scores WHERE student_id=? AND subject_id=? AND term_id=?");
      $st->execute([$u['id'],$subject['id'],$term['id']]);
      $theori=(float)($st->fetchColumn()??0);

      $st2=$this->db->prepare("SELECT uc_actors,uc_relations,uc_fit,uc_naming,uc_neat,
                                      act_complete,act_symbols,act_fit,act_neat,bonus
                               FROM uml_rubric_scores
                               WHERE student_id=? AND subject_id=? AND term_id=?");
      $st2->execute([$u['id'],$subject['id'],$term['id']]);
      $rubrik=$st2->fetch(PDO::FETCH_ASSOC)?:[];

      $praktik = array_sum($rubrik);
      if($praktik>100) $praktik=100; // clamp ke 100
      $total_nilai = round(($theori*0.30)+($praktik*0.70),2);
    }

    render_view('student_report.php',[
      'u'=>$u,'subject'=>$subject,'term'=>$term,
      'theori'=>$theori,'praktik'=>$praktik,'rubrik'=>$rubrik,
      'total_nilai'=>$total_nilai
    ]);
  }
}
