<?php $title='Rekap Nilai'; ?>
<h1>Rekapitulasi Nilai</h1>

<form method="get" class="stack-md" style="margin-bottom:1rem;">
  <input type="hidden" name="action" value="admin_rekap">
  <div class="row cols-2">
    <div>
      <label>Kelas</label>
      <select name="class_id" required>
        <option value="">- Pilih -</option>
        <?php foreach($classes as $c):?>
          <option value="<?=$c['id']?>" <?=($sel_class==$c['id']?'selected':'')?>><?=$c['name']?></option>
        <?php endforeach;?>
      </select>
    </div>
    <div>
      <label>Mata Pelajaran</label>
      <select name="subject_id" required>
        <option value="">- Pilih -</option>
        <?php foreach($subjects as $s):?>
          <option value="<?=$s['id']?>" <?=($sel_sub==$s['id']?'selected':'')?>><?=$s['name']?></option>
        <?php endforeach;?>
      </select>
    </div>
  </div>
  <div>
    <label>Semester / Term</label>
    <select name="term_id" required>
      <option value="">- Pilih -</option>
      <?php foreach($terms as $t):?>
        <option value="<?=$t['id']?>" <?=($sel_term==$t['id']?'selected':'')?>><?=$t['name']?></option>
      <?php endforeach;?>
    </select>
  </div>
  <div class="form-actions">
    <button type="submit">Tampilkan</button>
  </div>
</form>

<?php if($rows):?>
<div class="card">
  <table>
    <thead>
      <tr>
        <th>Nama Siswa</th>
        <th>Teori</th>
        <th>UML</th>
        <th>Total Akhir</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach($rows as $r): ?>
      <tr>
        <td><?=htmlspecialchars($r['full_name'])?></td>
        <td><?=number_format($r['teori'],2)?></td>
        <td><?=number_format($r['praktik'],2)?></td>
        <td><strong><?=number_format($r['total'],2)?></strong></td>
      </tr>
      <?php endforeach;?>
    </tbody>
  </table>
</div>
<?php elseif($sel_class||$sel_sub||$sel_term):?>
  <div class="alert alert-error">Belum ada data untuk kombinasi filter tersebut.</div>
<?php endif;?>
