<?php
// ========================================================
// FRONT CONTROLLER APLIKASI "SEKOLAH NILAI"
// ========================================================

declare(strict_types=1);

$APP_BASE = dirname(__DIR__);
$APP_SRC  = $APP_BASE . '/app';

// ------------------- LOAD CONFIG -----------------------
require $APP_SRC . '/config/db.php';
require $APP_SRC . '/config/auth.php';
if (is_file($APP_SRC . '/config/csrf.php')) require $APP_SRC . '/config/csrf.php';

// ------------------- AUTOLOAD CONTROLLER & MIDDLEWARE ---
spl_autoload_register(function($cls) use ($APP_SRC) {
  foreach (['controllers','middlewares'] as $dir) {
    $f = "$APP_SRC/$dir/$cls.php";
    if (is_file($f)) { require $f; return; }
  }
});

// ------------------- VIEW RENDER ------------------------
function render_view(string $v, array $d = []) {
  extract($d, EXTR_SKIP);
  $views = dirname(__DIR__) . '/app/views';
  include "$views/layout_top.php";
  include "$views/$v";
  include "$views/layout_bottom.php";
}

// ------------------- ROUTING ---------------------------
$action = $_GET['action'] ?? 'home';
$method = strtoupper($_SERVER['REQUEST_METHOD'] ?? 'GET');

try {
  switch ($action) {

    /* ---------- AUTH ---------- */
    case 'login':   (new AuthController($pdo))->login(); break;
    case 'logout':  (new AuthController($pdo))->logout(); break;

    /* ---------- ADMIN: DATA SISWA ---------- */
    case 'admin_students':        AdminOnly::check(); (new AdminStudents($pdo))->index(); break;
    case 'admin_students_create': AdminOnly::check(); (new AdminStudents($pdo))->create(); break;
    case 'admin_students_store':
      AdminOnly::check();
      if ($method !== 'POST') { http_response_code(405); exit; }
      if (function_exists('csrf_verify') && isset($_POST['csrf'])) csrf_verify();
      (new AdminStudents($pdo))->store();
      break;

    /* ---------- ADMIN: INPUT PENILAIAN (Teori + Rubrik UML) ---------- */
    case 'admin_input':       AdminOnly::check(); (new AdminInputNilai($pdo))->form(); break;
    case 'admin_input_save':
      AdminOnly::check();
      if ($method !== 'POST') { http_response_code(405); exit; }
      if (function_exists('csrf_verify') && isset($_POST['csrf'])) csrf_verify();
      (new AdminInputNilai($pdo))->save();
      break;

    /* ---------- SISWA: RAPOR ---------- */
    case 'student_report':   StudentOnly::check(); (new StudentReport($pdo))->show(); break;

    /* ---------- GANTI PASSWORD ---------- */
    case 'change_password':
      if (!current_user()) { header('Location:?action=login'); exit; }
      (new ChangePassword($pdo))->form();
      break;
    case 'change_password_save':
      if (!current_user()) { header('Location:?action=login'); exit; }
      if ($method !== 'POST') { http_response_code(405); exit; }
      if (function_exists('csrf_verify') && isset($_POST['csrf'])) csrf_verify();
      (new ChangePassword($pdo))->save();
      break;

    /* ---------- HOME ---------- */
    case 'home': {
      $u = current_user();
      if (!$u) {
        // Penting: paksa tamu ke route login agar POST selalu ke ?action=login
        header('Location: ?action=login'); exit;
      } else {
        header('Location: ?action=' . ($u['role'] === 'admin' ? 'admin_students' : 'student_report')); exit;
      }
    }
    /* ---------- ADMIN: REKAP NILAI ---------- */
    case 'admin_rekap':
      AdminOnly::check();
      (new AdminRekap($pdo))->index();
      break;


    /* ---------- DEFAULT 404 ---------- */
    default:
      http_response_code(404);
      render_view('login.php', ['error' => 'Halaman tidak ditemukan (404).']);
  }

} catch (Throwable $e) {
  http_response_code(500);
  echo "<pre style='background:#1e1e1e;color:#ff7b72;padding:10px;border-radius:8px'>".
       "Terjadi kesalahan:\n".htmlspecialchars($e->getMessage())."</pre>";
}
